-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Waktu pembuatan: 05 Nov 2025 pada 06.08
-- Versi server: 10.4.32-MariaDB
-- Versi PHP: 8.2.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `sistem_penilaian`
--

DELIMITER $$
--
-- Prosedur
--
CREATE DEFINER=`root`@`localhost` PROCEDURE `generate_laporan_rapor` (IN `p_siswa_id` INT, IN `p_tahun_ajaran_id` INT)   BEGIN
    SELECT 
        vs.nama_siswa,
        vs.nis,
        vs.nama_kelas,
        vs.tingkat,
        vs.jurusan,
        vs.tahun_ajaran,
        vs.semester,
        vs.kode_mapel,
        vs.nama_mapel,
        vs.kode_tp,
        vs.deskripsi_tp,
        vs.jenis_penilaian,
        vs.nilai_formatif,
        vs.deskripsi_formatif,
        vs.nilai_sumatif,
        ROUND(AVG(vs.nilai_formatif) OVER (PARTITION BY vs.mapel_id), 2) as rata_rata_mapel_formatif,
        ROUND(AVG(vs.nilai_sumatif) OVER (PARTITION BY vs.mapel_id), 2) as rata_rata_mapel_sumatif
    FROM view_nilai_siswa vs
    WHERE vs.siswa_id = p_siswa_id 
    AND vs.tahun_ajaran_id = p_tahun_ajaran_id
    ORDER BY vs.kode_mapel, vs.kode_tp;
END$$

CREATE DEFINER=`root`@`localhost` PROCEDURE `pindah_kelas_siswa` (IN `p_siswa_id` INT, IN `p_kelas_baru_id` INT, IN `p_tahun_ajaran_id` INT, IN `p_semester` ENUM('ganjil','genap'), IN `p_user_id` INT)   BEGIN
    DECLARE current_kelas INT;
    DECLARE current_ta INT;
    
    -- Dapatkan kelas dan tahun ajaran saat ini
    SELECT kelas_id INTO current_kelas FROM siswa WHERE id = p_siswa_id;
    SELECT id INTO current_ta FROM tahun_ajaran WHERE status = 'aktif' LIMIT 1;
    
    -- Update kelas siswa
    UPDATE siswa 
    SET kelas_id = p_kelas_baru_id, 
        updated_at = CURRENT_TIMESTAMP
    WHERE id = p_siswa_id;
    
    -- Tambahkan ke riwayat kelas
    INSERT INTO riwayat_kelas (siswa_id, kelas_id, tahun_ajaran_id, semester)
    VALUES (p_siswa_id, p_kelas_baru_id, p_tahun_ajaran_id, p_semester);
    
    -- Log aktivitas
    INSERT INTO log_aktivitas (user_id, aksi, tabel_terkait, id_terkait, data_sebelum, data_sesudah)
    VALUES (p_user_id, 'PINDAH_KELAS', 'siswa', p_siswa_id, 
            CONCAT('kelas_id:', current_kelas, ',tahun_ajaran_id:', current_ta),
            CONCAT('kelas_id:', p_kelas_baru_id, ',tahun_ajaran_id:', p_tahun_ajaran_id));
END$$

DELIMITER ;

-- --------------------------------------------------------

--
-- Struktur dari tabel `guru`
--

CREATE TABLE `guru` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `nip` varchar(20) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `guru`
--

INSERT INTO `guru` (`id`, `user_id`, `nip`) VALUES
(5, 12, '199201182020121002'),
(6, 19, '199001182020121002');

-- --------------------------------------------------------

--
-- Struktur dari tabel `guru_mapel`
--

CREATE TABLE `guru_mapel` (
  `id` int(11) NOT NULL,
  `guru_id` int(11) DEFAULT NULL,
  `mapel_id` int(11) DEFAULT NULL,
  `kelas_id` int(11) DEFAULT NULL,
  `tahun_ajaran_id` int(11) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `created_by` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `guru_mapel`
--

INSERT INTO `guru_mapel` (`id`, `guru_id`, `mapel_id`, `kelas_id`, `tahun_ajaran_id`, `created_at`, `updated_at`, `created_by`) VALUES
(11, 5, 6, 10, 1, '2025-11-03 15:35:59', NULL, NULL),
(12, 5, 6, 11, 1, '2025-11-04 13:12:05', NULL, NULL),
(13, 6, 7, 11, 1, '2025-11-04 14:09:33', NULL, NULL);

-- --------------------------------------------------------

--
-- Struktur dari tabel `kegiatan`
--

CREATE TABLE `kegiatan` (
  `id` int(11) NOT NULL,
  `mapel_id` int(11) DEFAULT NULL,
  `kelas_id` int(11) DEFAULT NULL,
  `tahun_ajaran_id` int(11) DEFAULT NULL,
  `nama_kegiatan` varchar(255) NOT NULL,
  `deskripsi` text DEFAULT NULL,
  `tanggal_mulai` date NOT NULL,
  `tanggal_selesai` date NOT NULL,
  `bobot` decimal(5,2) NOT NULL,
  `status` enum('aktif','nonaktif') DEFAULT 'aktif',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Struktur dari tabel `kegiatan_formatif`
--

CREATE TABLE `kegiatan_formatif` (
  `id` int(11) NOT NULL,
  `tp_id` int(11) DEFAULT NULL,
  `guru_id` int(11) DEFAULT NULL,
  `nama_kegiatan` varchar(255) NOT NULL,
  `jenis_kegiatan` enum('diskusi_kelas','diskusi_kelompok','kuis_singkat','presentasi','tugas_harian') DEFAULT NULL,
  `deskripsi` text DEFAULT NULL,
  `bobot` decimal(5,2) DEFAULT 0.00,
  `status` enum('draft','aktif','selesai') DEFAULT 'draft',
  `tanggal` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `updated_by` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Struktur dari tabel `kelas`
--

CREATE TABLE `kelas` (
  `id` int(11) NOT NULL,
  `tahun_ajaran_id` int(11) NOT NULL,
  `nama_kelas` varchar(20) NOT NULL,
  `tingkat` varchar(10) NOT NULL,
  `jurusan` varchar(50) DEFAULT 'Umum',
  `kapasitas` int(11) DEFAULT 32,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `kelas`
--

INSERT INTO `kelas` (`id`, `tahun_ajaran_id`, `nama_kelas`, `tingkat`, `jurusan`, `kapasitas`, `created_at`) VALUES
(5, 2, 'VIIA', '7', '', 32, '2025-10-23 08:34:25'),
(7, 2, 'VIIIB', '8', '', 32, '2025-11-03 04:51:22'),
(9, 2, 'IXC', '9', '', 32, '2025-11-03 04:52:04'),
(10, 1, 'VIIIB', '8', '', 32, '2025-11-03 14:41:25'),
(11, 1, 'VIIA', '7', '', 32, '2025-11-03 14:42:00');

-- --------------------------------------------------------

--
-- Struktur dari tabel `konfigurasi_bobot_nilai`
--

CREATE TABLE `konfigurasi_bobot_nilai` (
  `id` int(11) NOT NULL,
  `tahun_ajaran_id` int(11) NOT NULL,
  `jenis_nilai` enum('sumatif_tp','sumatif_akhir') NOT NULL,
  `bobot` decimal(5,2) NOT NULL,
  `tingkat` varchar(10) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `created_by` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Struktur dari tabel `konfigurasi_nilai`
--

CREATE TABLE `konfigurasi_nilai` (
  `id` int(11) NOT NULL,
  `tahun_ajaran_id` int(11) DEFAULT NULL,
  `presentase_sumatif_tp` decimal(5,2) DEFAULT 60.00,
  `presentase_sumatif_akhir` decimal(5,2) DEFAULT 40.00,
  `min_presentase_sumatif_tp` decimal(5,2) DEFAULT 50.00,
  `max_presentase_sumatif_tp` decimal(5,2) DEFAULT 80.00,
  `created_by` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Struktur dari tabel `log_aktivitas`
--

CREATE TABLE `log_aktivitas` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `aksi` varchar(100) NOT NULL,
  `tabel_terkait` varchar(50) NOT NULL,
  `id_terkait` int(11) DEFAULT NULL,
  `data_sebelum` text DEFAULT NULL,
  `data_sesudah` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Struktur dari tabel `mata_pelajaran`
--

CREATE TABLE `mata_pelajaran` (
  `id` int(11) NOT NULL,
  `kode_mapel` varchar(10) NOT NULL,
  `nama_mapel` varchar(100) NOT NULL,
  `deskripsi` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `mata_pelajaran`
--

INSERT INTO `mata_pelajaran` (`id`, `kode_mapel`, `nama_mapel`, `deskripsi`, `created_at`) VALUES
(6, 'INF', 'Informatika', '', '2025-10-23 07:45:27'),
(7, 'PJOK', 'Pendidikan Jasmani dan Keolahragaan', '', '2025-11-04 14:09:20');

-- --------------------------------------------------------

--
-- Struktur dari tabel `nilai_formatif`
--

CREATE TABLE `nilai_formatif` (
  `id` int(11) NOT NULL,
  `tp_id` int(11) DEFAULT NULL,
  `kegiatan_formatif_id` int(11) DEFAULT NULL,
  `siswa_id` int(11) DEFAULT NULL,
  `jenis` enum('observasi','tugas_tertulis','projek','portofolio','praktik','wawancara') NOT NULL,
  `nilai` decimal(5,2) NOT NULL,
  `bobot` decimal(5,2) DEFAULT 0.00,
  `deskripsi` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `updated_by` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `nilai_formatif`
--

INSERT INTO `nilai_formatif` (`id`, `tp_id`, `kegiatan_formatif_id`, `siswa_id`, `jenis`, `nilai`, `bobot`, `deskripsi`, `created_at`, `updated_at`, `updated_by`) VALUES
(2, 1, NULL, 3, 'portofolio', 85.00, 0.00, 'Melakukan apa', '2025-10-16 06:50:05', NULL, NULL),
(3, 1, NULL, 3, 'tugas_tertulis', 87.00, 0.00, 'formatif ke 2', '2025-10-17 16:34:34', NULL, NULL),
(4, 1, NULL, 3, 'praktik', 77.00, 0.00, 'formatif ke 3', '2025-10-17 16:35:18', NULL, NULL),
(5, 1, NULL, 4, 'observasi', 90.00, 0.00, 'masuk', '2025-10-17 17:42:19', NULL, NULL),
(6, 1, NULL, 4, 'projek', 90.00, 0.00, 'Bisa', '2025-10-17 17:42:42', NULL, NULL);

-- --------------------------------------------------------

--
-- Struktur dari tabel `nilai_sumatif`
--

CREATE TABLE `nilai_sumatif` (
  `id` int(11) NOT NULL,
  `tp_id` int(11) DEFAULT NULL,
  `siswa_id` int(11) DEFAULT NULL,
  `nilai` decimal(5,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `updated_by` int(11) DEFAULT NULL,
  `jenis_penilaian` enum('tes_kinerja','proyek_besar','portofolio_akhir','tes_lisan','tes_tertulis_subjektif','tes_tertulis_objektif') DEFAULT NULL,
  `deskripsi` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `nilai_sumatif`
--

INSERT INTO `nilai_sumatif` (`id`, `tp_id`, `siswa_id`, `nilai`, `created_at`, `updated_at`, `updated_by`, `jenis_penilaian`, `deskripsi`) VALUES
(1, 1, 3, 70.00, '2025-10-16 06:49:07', NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Struktur dari tabel `nilai_sumatif_akhir`
--

CREATE TABLE `nilai_sumatif_akhir` (
  `id` int(11) NOT NULL,
  `siswa_id` int(11) DEFAULT NULL,
  `mapel_id` int(11) DEFAULT NULL,
  `tahun_ajaran_id` int(11) DEFAULT NULL,
  `semester` enum('ganjil','genap') DEFAULT NULL,
  `nilai` decimal(5,2) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_by` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Struktur dari tabel `riwayat_kelas`
--

CREATE TABLE `riwayat_kelas` (
  `id` int(11) NOT NULL,
  `siswa_id` int(11) NOT NULL,
  `kelas_id` int(11) NOT NULL,
  `tahun_ajaran_id` int(11) NOT NULL,
  `semester` enum('ganjil','genap') NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `riwayat_kelas`
--

INSERT INTO `riwayat_kelas` (`id`, `siswa_id`, `kelas_id`, `tahun_ajaran_id`, `semester`, `created_at`) VALUES
(29, 8, 7, 2, 'genap', '2025-10-23 08:17:33'),
(30, 7, 7, 2, 'genap', '2025-10-23 08:34:38'),
(32, 9, 7, 2, 'genap', '2025-11-03 04:53:24'),
(33, 10, 5, 2, 'genap', '2025-11-03 04:54:39'),
(34, 11, 5, 2, 'genap', '2025-11-03 04:55:27'),
(35, 8, 10, 1, 'ganjil', '2025-11-03 22:40:27'),
(36, 9, 10, 1, 'ganjil', '2025-11-03 22:40:36'),
(37, 12, 11, 1, 'ganjil', '2025-11-04 14:08:34'),
(38, 7, 10, 1, 'ganjil', '2025-11-05 04:34:14'),
(39, 10, 11, 1, 'ganjil', '2025-11-05 04:34:21'),
(40, 11, 11, 1, 'ganjil', '2025-11-05 04:34:29');

-- --------------------------------------------------------

--
-- Struktur dari tabel `siswa`
--

CREATE TABLE `siswa` (
  `id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `nis` varchar(20) NOT NULL,
  `kelas_id` int(11) DEFAULT NULL,
  `status` enum('aktif','pindah','lulus','dropout') DEFAULT 'aktif',
  `tanggal_mutasi` date DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `siswa`
--

INSERT INTO `siswa` (`id`, `user_id`, `nis`, `kelas_id`, `status`, `tanggal_mutasi`, `created_by`, `updated_at`) VALUES
(7, 13, '2514', NULL, 'aktif', NULL, NULL, '2025-11-05 04:34:13'),
(8, 14, '2420', NULL, 'aktif', NULL, NULL, '2025-11-03 22:40:27'),
(9, 15, '2520', NULL, 'aktif', NULL, NULL, '2025-11-03 22:40:36'),
(10, 16, '2556', NULL, 'aktif', NULL, NULL, '2025-11-05 04:34:21'),
(11, 17, '2558', NULL, 'aktif', NULL, NULL, '2025-11-05 04:34:29'),
(12, 18, '1122', NULL, 'aktif', NULL, NULL, NULL);

--
-- Trigger `siswa`
--
DELIMITER $$
CREATE TRIGGER `before_update_siswa` BEFORE UPDATE ON `siswa` FOR EACH ROW BEGIN
    SET NEW.updated_at = CURRENT_TIMESTAMP;
END
$$
DELIMITER ;

-- --------------------------------------------------------

--
-- Struktur dari tabel `tahun_ajaran`
--

CREATE TABLE `tahun_ajaran` (
  `id` int(11) NOT NULL,
  `tahun_ajaran` varchar(20) NOT NULL,
  `semester` enum('ganjil','genap') NOT NULL,
  `status` enum('aktif','nonaktif') DEFAULT 'nonaktif',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `tahun_ajaran`
--

INSERT INTO `tahun_ajaran` (`id`, `tahun_ajaran`, `semester`, `status`, `created_at`) VALUES
(1, '2025/2026', 'ganjil', 'aktif', '2025-10-16 04:15:30'),
(2, '2025/2026', 'genap', 'nonaktif', '2025-10-17 18:25:47');

-- --------------------------------------------------------

--
-- Struktur dari tabel `tujuan_pembelajaran`
--

CREATE TABLE `tujuan_pembelajaran` (
  `id` int(11) NOT NULL,
  `mapel_id` int(11) DEFAULT NULL,
  `kelas_id` int(11) DEFAULT NULL,
  `tahun_ajaran_id` int(11) DEFAULT NULL,
  `kode_tp` varchar(20) NOT NULL,
  `jenjang` varchar(10) DEFAULT NULL,
  `deskripsi` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `status` enum('draft','aktif','nonaktif') DEFAULT 'draft'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `tujuan_pembelajaran`
--

INSERT INTO `tujuan_pembelajaran` (`id`, `mapel_id`, `kelas_id`, `tahun_ajaran_id`, `kode_tp`, `jenjang`, `deskripsi`, `created_at`, `status`) VALUES
(1, 1, NULL, 1, 'MTK7-TP1', NULL, 'Mampu mengopeasikan hitung penjumlahan bertingkat', '2025-10-16 04:33:18', 'draft'),
(2, 1, NULL, 1, 'MTK7-TP2', NULL, 'Melakukan penerapan operasi hitung dalam kehidupan sehari-hari', '2025-10-16 06:53:14', 'draft'),
(3, 1, NULL, 1, 'MTK7-TP3', NULL, 'Kelanjutan TP', '2025-10-17 16:32:45', 'draft'),
(4, 6, 11, 1, 'INF7-TP1s', '7', 'Memahami konsep dasar algoritma dan pemrograman', '2025-11-03 15:39:30', 'aktif'),
(5, 6, 11, 1, 'INF7-TP2', '7', 'Mampu membuat program sederhana menggunakan Scratch', '2025-11-03 15:39:30', 'aktif'),
(6, 6, 10, 1, 'INF8-TP1', '8', 'Memahami konsep pemrograman berorientasi objek', '2025-11-03 15:39:30', 'aktif'),
(7, 6, 10, 1, 'INF8-TP2', '8', 'Mampu membuat aplikasi web sederhana dengan HTML/CSS', '2025-11-03 15:39:30', 'aktif');

-- --------------------------------------------------------

--
-- Struktur dari tabel `users`
--

CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `level` enum('admin','guru','siswa') NOT NULL,
  `nama` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `users`
--

INSERT INTO `users` (`id`, `username`, `password`, `level`, `nama`, `created_at`) VALUES
(1, 'admin', '$2y$10$AetSe4prTrvDCY8TQ6GEzuSizQpYYh/1mvEz5FimzaOMBxeaPrD8e', 'admin', 'admin01', '0000-00-00 00:00:00'),
(12, 'ulinnuha', '$2y$10$0p/APdDkkYcbogHJHXz0ueRmCuxlCdWlJjzyqpPFCeruK4IrsyfLe', 'guru', 'Muhammad Ulinnuha Musthofa, S.Pd.', '2025-10-23 07:34:07'),
(13, '8B012024', '$2y$10$Bf4sBMu/l.hMD7lMUfhKueHoE7cYg/N3eZDiUJbghLPbeuGSf2Lum', 'siswa', 'ADHENIA NAJWA AZZAHRA', '2025-10-23 08:13:58'),
(14, '8B022024', '$2y$10$6oh7MLEP4uH6hPaPWpwZZuGN1qnFaDzm0jJK8xr0FSjxfn.hVWL9q', 'siswa', 'ADIB GALIH PANGESTU', '2025-10-23 08:17:33'),
(15, '8B032024', '$2y$10$22JXkBzAVL56YEz7NU5qoOUKPJHl6np6APJNw5SR4RWms//lnARAG', 'siswa', 'AYU SRIGATI', '2025-11-03 04:53:24'),
(16, '7A012025', '$2y$10$igOu8jo.1xd39.mEYRX3cu3gfz26add5dKvF27KOizAIWxYBe26Om', 'siswa', 'ADAFIAH AZILIA AR-RAHMAH', '2025-11-03 04:54:39'),
(17, '7A032025', '$2y$10$a8QUuaBuAuLcuZL6pDfsQevLKnYrax76mN/fBlkQ.1/xLrDE3iZle', 'siswa', 'AKHMAD IRFAN MAULANA', '2025-11-03 04:55:26'),
(18, '10101', '$2y$10$lIjWQPHYr.G4iWOYzdP69etiU/Zz6/ynsaBRbvihZPShS2VptNS7a', 'siswa', 'siswa tes', '2025-11-04 14:08:34'),
(19, 'pradan', '$2y$10$fD6o9PFogXOZ1YcsGIbxauVKwMCUjJy/rbaRl3s.UonGCd47AQsuq', 'guru', 'PRADANANG ARIF WIBOWO, S.Pd.', '2025-11-04 14:09:06');

-- --------------------------------------------------------

--
-- Stand-in struktur untuk tampilan `view_monitoring_sistem`
-- (Lihat di bawah untuk tampilan aktual)
--
CREATE TABLE `view_monitoring_sistem` (
`tahun_ajaran` varchar(20)
,`semester` enum('ganjil','genap')
,`total_siswa` bigint(21)
,`total_guru` bigint(21)
,`total_kelas` bigint(21)
,`total_mapel` bigint(21)
,`total_tp` bigint(21)
,`total_nilai_formatif` bigint(21)
,`total_nilai_sumatif` bigint(21)
,`rata_rata_nilai_formatif` decimal(9,6)
,`rata_rata_nilai_sumatif` decimal(9,6)
);

-- --------------------------------------------------------

--
-- Stand-in struktur untuk tampilan `view_nilai_siswa`
-- (Lihat di bawah untuk tampilan aktual)
--
CREATE TABLE `view_nilai_siswa` (
`siswa_id` int(11)
,`nis` varchar(20)
,`user_id` int(11)
,`nama_siswa` varchar(100)
,`nama_kelas` varchar(20)
,`tingkat` varchar(10)
,`jurusan` varchar(50)
,`tahun_ajaran_id` int(11)
,`tahun_ajaran` varchar(20)
,`semester` enum('ganjil','genap')
,`tp_id` int(11)
,`kode_tp` varchar(20)
,`deskripsi_tp` text
,`mapel_id` int(11)
,`kode_mapel` varchar(10)
,`nama_mapel` varchar(100)
,`jenis_penilaian` enum('observasi','tugas_tertulis','projek','portofolio','praktik','wawancara')
,`nilai_formatif` decimal(5,2)
,`deskripsi_formatif` text
,`nilai_sumatif` decimal(5,2)
,`tgl_input_formatif` timestamp
,`tgl_input_sumatif` timestamp
);

-- --------------------------------------------------------

--
-- Stand-in struktur untuk tampilan `view_transkrip_siswa`
-- (Lihat di bawah untuk tampilan aktual)
--
CREATE TABLE `view_transkrip_siswa` (
`siswa_id` int(11)
,`nis` varchar(20)
,`nama_siswa` varchar(100)
,`tahun_ajaran` varchar(20)
,`semester` enum('ganjil','genap')
,`kode_mapel` varchar(10)
,`nama_mapel` varchar(100)
,`jumlah_tp` bigint(21)
,`rata_rata_formatif` decimal(6,2)
,`rata_rata_sumatif` decimal(6,2)
,`tgl_penilaian_terakhir` varchar(19)
);

-- --------------------------------------------------------

--
-- Struktur dari tabel `wali_kelas`
--

CREATE TABLE `wali_kelas` (
  `id` int(11) NOT NULL,
  `guru_id` int(11) NOT NULL,
  `kelas_id` int(11) NOT NULL,
  `tahun_ajaran_id` int(11) NOT NULL,
  `semester` enum('ganjil','genap') NOT NULL DEFAULT 'ganjil',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NULL DEFAULT NULL ON UPDATE current_timestamp(),
  `created_by` int(11) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data untuk tabel `wali_kelas`
--

INSERT INTO `wali_kelas` (`id`, `guru_id`, `kelas_id`, `tahun_ajaran_id`, `semester`, `created_at`, `updated_at`, `created_by`) VALUES
(5, 5, 10, 1, 'ganjil', '2025-11-03 14:42:46', NULL, 1),
(6, 6, 11, 1, 'ganjil', '2025-11-05 04:34:50', NULL, 1);

-- --------------------------------------------------------

--
-- Struktur untuk view `view_monitoring_sistem`
--
DROP TABLE IF EXISTS `view_monitoring_sistem`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `view_monitoring_sistem`  AS SELECT `ta`.`tahun_ajaran` AS `tahun_ajaran`, `ta`.`semester` AS `semester`, count(distinct `s`.`id`) AS `total_siswa`, count(distinct `g`.`id`) AS `total_guru`, count(distinct `k`.`id`) AS `total_kelas`, count(distinct `m`.`id`) AS `total_mapel`, count(distinct `tp`.`id`) AS `total_tp`, count(distinct `nf`.`id`) AS `total_nilai_formatif`, count(distinct `ns`.`id`) AS `total_nilai_sumatif`, avg(`nf`.`nilai`) AS `rata_rata_nilai_formatif`, avg(`ns`.`nilai`) AS `rata_rata_nilai_sumatif` FROM ((((((((`tahun_ajaran` `ta` left join `riwayat_kelas` `rk` on(`ta`.`id` = `rk`.`tahun_ajaran_id`)) left join `siswa` `s` on(`rk`.`siswa_id` = `s`.`id` and `s`.`status` = 'aktif')) left join `guru` `g` on(1 = 1)) left join `kelas` `k` on(1 = 1)) left join `mata_pelajaran` `m` on(1 = 1)) left join `tujuan_pembelajaran` `tp` on(`ta`.`id` = `tp`.`tahun_ajaran_id`)) left join `nilai_formatif` `nf` on(`tp`.`id` = `nf`.`tp_id`)) left join `nilai_sumatif` `ns` on(`tp`.`id` = `ns`.`tp_id`)) WHERE `ta`.`status` = 'aktif' GROUP BY `ta`.`id`, `ta`.`tahun_ajaran`, `ta`.`semester` ;

-- --------------------------------------------------------

--
-- Struktur untuk view `view_nilai_siswa`
--
DROP TABLE IF EXISTS `view_nilai_siswa`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `view_nilai_siswa`  AS SELECT `s`.`id` AS `siswa_id`, `s`.`nis` AS `nis`, `s`.`user_id` AS `user_id`, `u`.`nama` AS `nama_siswa`, `k`.`nama_kelas` AS `nama_kelas`, `k`.`tingkat` AS `tingkat`, `k`.`jurusan` AS `jurusan`, `ta`.`id` AS `tahun_ajaran_id`, `ta`.`tahun_ajaran` AS `tahun_ajaran`, `ta`.`semester` AS `semester`, `tp`.`id` AS `tp_id`, `tp`.`kode_tp` AS `kode_tp`, `tp`.`deskripsi` AS `deskripsi_tp`, `m`.`id` AS `mapel_id`, `m`.`kode_mapel` AS `kode_mapel`, `m`.`nama_mapel` AS `nama_mapel`, `nf`.`jenis` AS `jenis_penilaian`, `nf`.`nilai` AS `nilai_formatif`, `nf`.`deskripsi` AS `deskripsi_formatif`, `ns`.`nilai` AS `nilai_sumatif`, `nf`.`created_at` AS `tgl_input_formatif`, `ns`.`created_at` AS `tgl_input_sumatif` FROM (((((((((`siswa` `s` join `users` `u` on(`s`.`user_id` = `u`.`id`)) join `riwayat_kelas` `rk` on(`s`.`id` = `rk`.`siswa_id`)) join `tahun_ajaran` `ta` on(`rk`.`tahun_ajaran_id` = `ta`.`id` and `ta`.`status` = 'aktif')) join `kelas` `k` on(`rk`.`kelas_id` = `k`.`id`)) left join `guru_mapel` `gm` on(`gm`.`kelas_id` = `k`.`id` and `gm`.`tahun_ajaran_id` = `ta`.`id`)) left join `tujuan_pembelajaran` `tp` on(`tp`.`mapel_id` = `gm`.`mapel_id` and `tp`.`tahun_ajaran_id` = `ta`.`id`)) left join `mata_pelajaran` `m` on(`tp`.`mapel_id` = `m`.`id`)) left join `nilai_formatif` `nf` on(`tp`.`id` = `nf`.`tp_id` and `s`.`id` = `nf`.`siswa_id`)) left join `nilai_sumatif` `ns` on(`tp`.`id` = `ns`.`tp_id` and `s`.`id` = `ns`.`siswa_id`)) WHERE `s`.`status` = 'aktif' ;

-- --------------------------------------------------------

--
-- Struktur untuk view `view_transkrip_siswa`
--
DROP TABLE IF EXISTS `view_transkrip_siswa`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `view_transkrip_siswa`  AS SELECT `s`.`id` AS `siswa_id`, `s`.`nis` AS `nis`, `u`.`nama` AS `nama_siswa`, `ta`.`tahun_ajaran` AS `tahun_ajaran`, `ta`.`semester` AS `semester`, `m`.`kode_mapel` AS `kode_mapel`, `m`.`nama_mapel` AS `nama_mapel`, count(distinct `tp`.`id`) AS `jumlah_tp`, round(avg(`nf`.`nilai`),2) AS `rata_rata_formatif`, round(avg(`ns`.`nilai`),2) AS `rata_rata_sumatif`, max(greatest(coalesce(`nf`.`created_at`,0),coalesce(`ns`.`created_at`,0))) AS `tgl_penilaian_terakhir` FROM ((((((((`siswa` `s` join `users` `u` on(`s`.`user_id` = `u`.`id`)) join `riwayat_kelas` `rk` on(`s`.`id` = `rk`.`siswa_id`)) join `tahun_ajaran` `ta` on(`rk`.`tahun_ajaran_id` = `ta`.`id`)) join `guru_mapel` `gm` on(`gm`.`kelas_id` = `rk`.`kelas_id` and `gm`.`tahun_ajaran_id` = `ta`.`id`)) join `tujuan_pembelajaran` `tp` on(`tp`.`mapel_id` = `gm`.`mapel_id` and `tp`.`tahun_ajaran_id` = `ta`.`id`)) join `mata_pelajaran` `m` on(`tp`.`mapel_id` = `m`.`id`)) left join `nilai_formatif` `nf` on(`tp`.`id` = `nf`.`tp_id` and `s`.`id` = `nf`.`siswa_id`)) left join `nilai_sumatif` `ns` on(`tp`.`id` = `ns`.`tp_id` and `s`.`id` = `ns`.`siswa_id`)) WHERE `s`.`status` = 'aktif' GROUP BY `s`.`id`, `s`.`nis`, `u`.`nama`, `ta`.`tahun_ajaran`, `ta`.`semester`, `m`.`kode_mapel`, `m`.`nama_mapel` ;

--
-- Indexes for dumped tables
--

--
-- Indeks untuk tabel `guru`
--
ALTER TABLE `guru`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `nip` (`nip`),
  ADD KEY `user_id` (`user_id`);

--
-- Indeks untuk tabel `guru_mapel`
--
ALTER TABLE `guru_mapel`
  ADD PRIMARY KEY (`id`),
  ADD KEY `mapel_id` (`mapel_id`),
  ADD KEY `tahun_ajaran_id` (`tahun_ajaran_id`),
  ADD KEY `kelas_id` (`kelas_id`),
  ADD KEY `idx_guru_mapel_composite` (`guru_id`,`mapel_id`,`kelas_id`,`tahun_ajaran_id`),
  ADD KEY `idx_guru_mapel_guru` (`guru_id`);

--
-- Indeks untuk tabel `kegiatan`
--
ALTER TABLE `kegiatan`
  ADD PRIMARY KEY (`id`),
  ADD KEY `mapel_id` (`mapel_id`),
  ADD KEY `kelas_id` (`kelas_id`),
  ADD KEY `tahun_ajaran_id` (`tahun_ajaran_id`);

--
-- Indeks untuk tabel `kegiatan_formatif`
--
ALTER TABLE `kegiatan_formatif`
  ADD PRIMARY KEY (`id`),
  ADD KEY `tp_id` (`tp_id`),
  ADD KEY `guru_id` (`guru_id`);

--
-- Indeks untuk tabel `kelas`
--
ALTER TABLE `kelas`
  ADD PRIMARY KEY (`id`),
  ADD KEY `tahun_ajaran_id` (`tahun_ajaran_id`);

--
-- Indeks untuk tabel `konfigurasi_bobot_nilai`
--
ALTER TABLE `konfigurasi_bobot_nilai`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_konfigurasi` (`tahun_ajaran_id`,`jenis_nilai`,`tingkat`),
  ADD KEY `tahun_ajaran_id` (`tahun_ajaran_id`);

--
-- Indeks untuk tabel `konfigurasi_nilai`
--
ALTER TABLE `konfigurasi_nilai`
  ADD PRIMARY KEY (`id`),
  ADD KEY `tahun_ajaran_id` (`tahun_ajaran_id`);

--
-- Indeks untuk tabel `log_aktivitas`
--
ALTER TABLE `log_aktivitas`
  ADD PRIMARY KEY (`id`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `tabel_terkait` (`tabel_terkait`),
  ADD KEY `created_at` (`created_at`);

--
-- Indeks untuk tabel `mata_pelajaran`
--
ALTER TABLE `mata_pelajaran`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `kode_mapel` (`kode_mapel`);

--
-- Indeks untuk tabel `nilai_formatif`
--
ALTER TABLE `nilai_formatif`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_nilai_siswa_tp` (`siswa_id`,`tp_id`),
  ADD KEY `idx_nilai_tp_siswa` (`tp_id`,`siswa_id`),
  ADD KEY `idx_nilai_kegiatan` (`kegiatan_formatif_id`);

--
-- Indeks untuk tabel `nilai_sumatif`
--
ALTER TABLE `nilai_sumatif`
  ADD PRIMARY KEY (`id`),
  ADD KEY `siswa_id` (`siswa_id`),
  ADD KEY `idx_nilai_sumatif_composite` (`tp_id`,`siswa_id`),
  ADD KEY `idx_nilai_sumatif_tp` (`tp_id`);

--
-- Indeks untuk tabel `nilai_sumatif_akhir`
--
ALTER TABLE `nilai_sumatif_akhir`
  ADD PRIMARY KEY (`id`),
  ADD KEY `siswa_id` (`siswa_id`),
  ADD KEY `mapel_id` (`mapel_id`),
  ADD KEY `tahun_ajaran_id` (`tahun_ajaran_id`);

--
-- Indeks untuk tabel `riwayat_kelas`
--
ALTER TABLE `riwayat_kelas`
  ADD PRIMARY KEY (`id`),
  ADD KEY `siswa_id` (`siswa_id`),
  ADD KEY `kelas_id` (`kelas_id`),
  ADD KEY `tahun_ajaran_id` (`tahun_ajaran_id`),
  ADD KEY `idx_siswa_tahun` (`siswa_id`,`tahun_ajaran_id`),
  ADD KEY `idx_riwayat_tahun` (`tahun_ajaran_id`);

--
-- Indeks untuk tabel `siswa`
--
ALTER TABLE `siswa`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `nis` (`nis`),
  ADD KEY `user_id` (`user_id`),
  ADD KEY `kelas_id` (`kelas_id`),
  ADD KEY `idx_siswa_status` (`status`);

--
-- Indeks untuk tabel `tahun_ajaran`
--
ALTER TABLE `tahun_ajaran`
  ADD PRIMARY KEY (`id`),
  ADD KEY `idx_ta_status` (`status`);

--
-- Indeks untuk tabel `tujuan_pembelajaran`
--
ALTER TABLE `tujuan_pembelajaran`
  ADD PRIMARY KEY (`id`),
  ADD KEY `fk_tp_tahun_ajaran` (`tahun_ajaran_id`),
  ADD KEY `idx_tp_mapel_ta` (`mapel_id`,`tahun_ajaran_id`),
  ADD KEY `fk_tp_kelas` (`kelas_id`);

--
-- Indeks untuk tabel `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`);

--
-- Indeks untuk tabel `wali_kelas`
--
ALTER TABLE `wali_kelas`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `unique_kelas_tahun_semester` (`kelas_id`,`tahun_ajaran_id`,`semester`),
  ADD KEY `guru_id` (`guru_id`),
  ADD KEY `tahun_ajaran_id` (`tahun_ajaran_id`),
  ADD KEY `created_by` (`created_by`);

--
-- AUTO_INCREMENT untuk tabel yang dibuang
--

--
-- AUTO_INCREMENT untuk tabel `guru`
--
ALTER TABLE `guru`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT untuk tabel `guru_mapel`
--
ALTER TABLE `guru_mapel`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=14;

--
-- AUTO_INCREMENT untuk tabel `kegiatan`
--
ALTER TABLE `kegiatan`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT untuk tabel `kegiatan_formatif`
--
ALTER TABLE `kegiatan_formatif`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT untuk tabel `kelas`
--
ALTER TABLE `kelas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT untuk tabel `konfigurasi_bobot_nilai`
--
ALTER TABLE `konfigurasi_bobot_nilai`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT untuk tabel `konfigurasi_nilai`
--
ALTER TABLE `konfigurasi_nilai`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT untuk tabel `log_aktivitas`
--
ALTER TABLE `log_aktivitas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT untuk tabel `mata_pelajaran`
--
ALTER TABLE `mata_pelajaran`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT untuk tabel `nilai_formatif`
--
ALTER TABLE `nilai_formatif`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT untuk tabel `nilai_sumatif`
--
ALTER TABLE `nilai_sumatif`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT untuk tabel `nilai_sumatif_akhir`
--
ALTER TABLE `nilai_sumatif_akhir`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT untuk tabel `riwayat_kelas`
--
ALTER TABLE `riwayat_kelas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=41;

--
-- AUTO_INCREMENT untuk tabel `siswa`
--
ALTER TABLE `siswa`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=13;

--
-- AUTO_INCREMENT untuk tabel `tahun_ajaran`
--
ALTER TABLE `tahun_ajaran`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT untuk tabel `tujuan_pembelajaran`
--
ALTER TABLE `tujuan_pembelajaran`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=12;

--
-- AUTO_INCREMENT untuk tabel `users`
--
ALTER TABLE `users`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=20;

--
-- AUTO_INCREMENT untuk tabel `wali_kelas`
--
ALTER TABLE `wali_kelas`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- Ketidakleluasaan untuk tabel pelimpahan (Dumped Tables)
--

--
-- Ketidakleluasaan untuk tabel `guru`
--
ALTER TABLE `guru`
  ADD CONSTRAINT `guru_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Ketidakleluasaan untuk tabel `guru_mapel`
--
ALTER TABLE `guru_mapel`
  ADD CONSTRAINT `guru_mapel_ibfk_1` FOREIGN KEY (`guru_id`) REFERENCES `guru` (`id`),
  ADD CONSTRAINT `guru_mapel_ibfk_2` FOREIGN KEY (`mapel_id`) REFERENCES `mata_pelajaran` (`id`),
  ADD CONSTRAINT `guru_mapel_ibfk_3` FOREIGN KEY (`tahun_ajaran_id`) REFERENCES `tahun_ajaran` (`id`),
  ADD CONSTRAINT `guru_mapel_ibfk_4` FOREIGN KEY (`kelas_id`) REFERENCES `kelas` (`id`);

--
-- Ketidakleluasaan untuk tabel `kegiatan`
--
ALTER TABLE `kegiatan`
  ADD CONSTRAINT `kegiatan_ibfk_1` FOREIGN KEY (`mapel_id`) REFERENCES `mata_pelajaran` (`id`),
  ADD CONSTRAINT `kegiatan_ibfk_2` FOREIGN KEY (`kelas_id`) REFERENCES `kelas` (`id`),
  ADD CONSTRAINT `kegiatan_ibfk_3` FOREIGN KEY (`tahun_ajaran_id`) REFERENCES `tahun_ajaran` (`id`);

--
-- Ketidakleluasaan untuk tabel `kegiatan_formatif`
--
ALTER TABLE `kegiatan_formatif`
  ADD CONSTRAINT `kegiatan_formatif_ibfk_1` FOREIGN KEY (`tp_id`) REFERENCES `tujuan_pembelajaran` (`id`),
  ADD CONSTRAINT `kegiatan_formatif_ibfk_2` FOREIGN KEY (`guru_id`) REFERENCES `guru` (`id`);

--
-- Ketidakleluasaan untuk tabel `kelas`
--
ALTER TABLE `kelas`
  ADD CONSTRAINT `kelas_ibfk_1` FOREIGN KEY (`tahun_ajaran_id`) REFERENCES `tahun_ajaran` (`id`) ON DELETE CASCADE;

--
-- Ketidakleluasaan untuk tabel `konfigurasi_bobot_nilai`
--
ALTER TABLE `konfigurasi_bobot_nilai`
  ADD CONSTRAINT `fk_konfigurasi_ta` FOREIGN KEY (`tahun_ajaran_id`) REFERENCES `tahun_ajaran` (`id`);

--
-- Ketidakleluasaan untuk tabel `konfigurasi_nilai`
--
ALTER TABLE `konfigurasi_nilai`
  ADD CONSTRAINT `konfigurasi_nilai_ibfk_1` FOREIGN KEY (`tahun_ajaran_id`) REFERENCES `tahun_ajaran` (`id`);

--
-- Ketidakleluasaan untuk tabel `log_aktivitas`
--
ALTER TABLE `log_aktivitas`
  ADD CONSTRAINT `log_aktivitas_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE;

--
-- Ketidakleluasaan untuk tabel `nilai_formatif`
--
ALTER TABLE `nilai_formatif`
  ADD CONSTRAINT `fk_nilai_kegiatan_formatif` FOREIGN KEY (`kegiatan_formatif_id`) REFERENCES `kegiatan_formatif` (`id`),
  ADD CONSTRAINT `nilai_formatif_ibfk_1` FOREIGN KEY (`tp_id`) REFERENCES `tujuan_pembelajaran` (`id`),
  ADD CONSTRAINT `nilai_formatif_ibfk_2` FOREIGN KEY (`siswa_id`) REFERENCES `siswa` (`id`);

--
-- Ketidakleluasaan untuk tabel `nilai_sumatif`
--
ALTER TABLE `nilai_sumatif`
  ADD CONSTRAINT `nilai_sumatif_ibfk_1` FOREIGN KEY (`tp_id`) REFERENCES `tujuan_pembelajaran` (`id`),
  ADD CONSTRAINT `nilai_sumatif_ibfk_2` FOREIGN KEY (`siswa_id`) REFERENCES `siswa` (`id`);

--
-- Ketidakleluasaan untuk tabel `nilai_sumatif_akhir`
--
ALTER TABLE `nilai_sumatif_akhir`
  ADD CONSTRAINT `nilai_sumatif_akhir_ibfk_1` FOREIGN KEY (`siswa_id`) REFERENCES `siswa` (`id`),
  ADD CONSTRAINT `nilai_sumatif_akhir_ibfk_2` FOREIGN KEY (`mapel_id`) REFERENCES `mata_pelajaran` (`id`),
  ADD CONSTRAINT `nilai_sumatif_akhir_ibfk_3` FOREIGN KEY (`tahun_ajaran_id`) REFERENCES `tahun_ajaran` (`id`);

--
-- Ketidakleluasaan untuk tabel `siswa`
--
ALTER TABLE `siswa`
  ADD CONSTRAINT `siswa_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `siswa_ibfk_2` FOREIGN KEY (`kelas_id`) REFERENCES `kelas` (`id`);

--
-- Ketidakleluasaan untuk tabel `tujuan_pembelajaran`
--
ALTER TABLE `tujuan_pembelajaran`
  ADD CONSTRAINT `fk_tp_kelas` FOREIGN KEY (`kelas_id`) REFERENCES `kelas` (`id`),
  ADD CONSTRAINT `fk_tp_mapel` FOREIGN KEY (`mapel_id`) REFERENCES `mata_pelajaran` (`id`) ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_tp_tahun_ajaran` FOREIGN KEY (`tahun_ajaran_id`) REFERENCES `tahun_ajaran` (`id`) ON UPDATE CASCADE;

--
-- Ketidakleluasaan untuk tabel `wali_kelas`
--
ALTER TABLE `wali_kelas`
  ADD CONSTRAINT `wali_kelas_ibfk_1` FOREIGN KEY (`guru_id`) REFERENCES `guru` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `wali_kelas_ibfk_2` FOREIGN KEY (`kelas_id`) REFERENCES `kelas` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `wali_kelas_ibfk_3` FOREIGN KEY (`tahun_ajaran_id`) REFERENCES `tahun_ajaran` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `wali_kelas_ibfk_4` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
